package gov.va.vinci.dart.json.builder;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.json.PersonDetailsView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestPersonDetailsViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		PersonDetailsViewBuilder builder = SingletonShim.getBean(PersonDetailsViewBuilder.class);
		
		try {
			builder.build((Person)null, true);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1004);
		
		PersonDetailsView pdv = builder.build(pers, true);
		Assert.assertNotNull(pdv);
		Assert.assertEquals(pdv.getId(), 1004);
		Assert.assertEquals(pdv.getName(), pers.getName());
		Assert.assertEquals(pdv.getDescription(), pers.getDescription());
		Assert.assertEquals(pdv.getFullName(), pers.getFullName());
		Assert.assertEquals(pdv.getLocationId(), pers.getLocation().getId());
		Assert.assertEquals(pdv.getLocationName(), pers.getLocation().getName());
		Assert.assertNotNull(pdv.getGroups());
		Assert.assertNotNull(pdv.getRoles());
	}
	
}
